<map version="0.8.1">
<!-- To view this file, download free mind mapping software FreeMind from http://freemind.sourceforge.net -->
<node CREATED="1245790772107" ID="Freemind_Link_128912200" MODIFIED="1248002222339" TEXT="Spotlight Programming">
<node CREATED="1245792153962" ID="Freemind_Link_282756727" MODIFIED="1248183803060" POSITION="left" TEXT="Spotlight" VSHIFT="-58">
<node CREATED="1247986311402" ID="Freemind_Link_918246071" MODIFIED="1248002232784" TEXT="Definition" VSHIFT="5">
<node CREATED="1247986333475" ID="Freemind_Link_1562504316" MODIFIED="1247986337370" TEXT="Spotlight is a fast, extensible, desktop search technology that allows users to organize and search for files based on metadata."/>
</node>
<node CREATED="1245792033824" HGAP="23" ID="Freemind_Link_311183402" MODIFIED="1248157296963" TEXT="Technologies" VSHIFT="49">
<node CREATED="1245792039095" ID="Freemind_Link_1240587757" MODIFIED="1245792290586" TEXT="Database (&quot;Spotlight Store&quot;)">
<node CREATED="1245792054166" ID="Freemind_Link_291417618" MODIFIED="1245792066292" TEXT="meta-data store"/>
<node CREATED="1245792066937" ID="Freemind_Link_573287696" MODIFIED="1245792072036" TEXT="content index">
<node CREATED="1245791810707" ID="Freemind_Link_1516833373" MODIFIED="1248002075239" TEXT="SearchKit"/>
</node>
<node CREATED="1245792317758" ID="Freemind_Link_1975600316" MODIFIED="1245792487490" TEXT="one per filesystem"/>
</node>
<node CREATED="1245792077865" ID="Freemind_Link_386697718" MODIFIED="1245792096357" TEXT="Query API "/>
<node CREATED="1245792113074" ID="Freemind_Link_309682162" MODIFIED="1245792127077" TEXT="Importer plugins"/>
<node CREATED="1245792127825" ID="Freemind_Link_1776345197" MODIFIED="1245792148518" TEXT="Plugin API"/>
</node>
</node>
<node CREATED="1248183675042" ID="Freemind_Link_753868305" MODIFIED="1248183799435" POSITION="left" TEXT="Concepts" VSHIFT="-37">
<node CREATED="1248183682587" ID="Freemind_Link_1289169494" MODIFIED="1248183689193" TEXT="Metadata">
<node CREATED="1248183690067" ID="Freemind_Link_1962396921" MODIFIED="1248183713303" TEXT="Attribute / Value">
<node CREATED="1248157546748" ID="Freemind_Link_235899911" MODIFIED="1248162282005" TEXT="Metadata attribute" VSHIFT="21">
<node CREATED="1248160358985" ID="Freemind_Link_717788284" MODIFIED="1248161861734" TEXT="predefined">
<node CREATED="1248160363537" ID="Freemind_Link_1664985539" MODIFIED="1248160371253" TEXT="File system"/>
<node CREATED="1248160371753" ID="Freemind_Link_1912738061" MODIFIED="1248160376925" TEXT="Image related"/>
<node CREATED="1248160377857" ID="Freemind_Link_970594372" MODIFIED="1248160386861" TEXT="Video related"/>
<node CREATED="1248160387609" ID="Freemind_Link_1469097832" MODIFIED="1248160392829" TEXT="Audio related"/>
<node CREATED="1248160394338" ID="Freemind_Link_1504887854" MODIFIED="1248160409260" TEXT="&quot;common&quot; attributes">
<node CREATED="1248160409738" ID="Freemind_Link_829478151" MODIFIED="1248160415030" TEXT="author"/>
<node CREATED="1248160415882" ID="Freemind_Link_327846604" MODIFIED="1248160417781" TEXT="city"/>
<node CREATED="1248160418282" ID="Freemind_Link_1166044218" MODIFIED="1248160425294" TEXT="email"/>
<node CREATED="1248160425962" ID="Freemind_Link_92017291" MODIFIED="1248160429902" TEXT="organization"/>
<node CREATED="1248160430682" ID="Freemind_Link_894208890" MODIFIED="1248160432238" TEXT="..."/>
</node>
<node CREATED="1247942358779" ID="Freemind_Link_455922734" MODIFIED="1247942365064" TEXT="Special Attributes">
<node CREATED="1247942365536" ID="Freemind_Link_1866957341" MODIFIED="1247942375488" TEXT="kMDItemPath">
<node CREATED="1247942420321" ID="Freemind_Link_406024028" MODIFIED="1247942437288" TEXT="&quot;expensive&quot; attribute, "/>
<node CREATED="1248009300232" ID="Freemind_Link_773887986" MODIFIED="1248009327235" TEXT="retrievable, but not use in query"/>
</node>
<node CREATED="1247942377865" ID="Freemind_Link_1947562426" MODIFIED="1247942390116" TEXT="lMDItemTextContent">
<node CREATED="1247942390888" ID="Freemind_Link_1641942787" MODIFIED="1247942407348" TEXT="use in query but not retrievable"/>
</node>
</node>
<node CREATED="1248161798879" ID="Freemind_Link_736781437" LINK="#Freemind_Link_1710335322" MODIFIED="1248163673922" TEXT="Spotlight Metadata Attributes Reference"/>
</node>
<node CREATED="1248160932949" ID="Freemind_Link_430301115" MODIFIED="1248160936447" TEXT="custom">
<node CREATED="1248160937021" ID="Freemind_Link_1317585311" MODIFIED="1248160960566" TEXT="only if existing (predefined) key not appropriate"/>
<node CREATED="1248162175678" ID="Freemind_Link_718986840" LINK="#Freemind_Link_606554577" MODIFIED="1248162218440" TEXT="Spotlight Importer"/>
</node>
<node CREATED="1248161977522" ID="Freemind_Link_72815296" MODIFIED="1248162308765" TEXT="Properties">
<node CREATED="1248162817692" ID="Freemind_Link_1519717036" MODIFIED="1248163101573" TEXT="name">
<node CREATED="1248161132713" ID="Freemind_Link_1307146436" MODIFIED="1248161142010" TEXT="Naming Convention">
<node CREATED="1248161142545" ID="Freemind_Link_1828931113" MODIFIED="1248161180611" TEXT="reverse DNS naming with _ instead of .">
<node CREATED="1248161181130" ID="Freemind_Link_809603735" MODIFIED="1248161189590" TEXT="com_apple_mail"/>
</node>
</node>
</node>
<node CREATED="1248161239683" ID="Freemind_Link_974349911" MODIFIED="1248163091773" TEXT="(Value Object) type">
<node CREATED="1248161250123" ID="Freemind_Link_1045286613" MODIFIED="1248161256351" TEXT="CFString"/>
<node CREATED="1248161259595" ID="Freemind_Link_1957070133" MODIFIED="1248161263326" TEXT="CFNumber"/>
<node CREATED="1248161263803" ID="Freemind_Link_515173175" MODIFIED="1248161268599" TEXT="CFBoolean"/>
<node CREATED="1248161269180" ID="Freemind_Link_104717448" MODIFIED="1248161274495" TEXT="CFDate"/>
</node>
<node CREATED="1248161944050" ID="Freemind_Link_1831533400" MODIFIED="1248161972086" TEXT="multivalue">
<node CREATED="1248162979767" ID="Freemind_Link_202566611" MODIFIED="1248162988595" TEXT="array of values"/>
</node>
<node CREATED="1248162923118" ID="Freemind_Link_1164018017" MODIFIED="1248162931738" TEXT="uniqued">
<node CREATED="1248163011920" ID="Freemind_Link_1894379647" MODIFIED="1248163032716" TEXT="used when a very small number of values is possible"/>
</node>
<node CREATED="1248163035120" ID="Freemind_Link_585324474" MODIFIED="1248163044764" TEXT="nosearch">
<node CREATED="1248163140867" ID="Freemind_Link_1603504399" MODIFIED="1248163192286" TEXT="attribute only searched when specifically declared"/>
<node CREATED="1248163192868" ID="Freemind_Link_1726305069" MODIFIED="1248163208504" TEXT="ignored in wildcard searches"/>
</node>
<node CREATED="1248162066564" ID="Freemind_Link_496044689" MODIFIED="1248162085584" TEXT="Display Name"/>
<node CREATED="1248162086157" ID="Freemind_Link_449712207" MODIFIED="1248162089384" TEXT="Description"/>
</node>
</node>
<node CREATED="1248161024415" ID="Freemind_Link_292449073" MODIFIED="1248161032423" TEXT="Metadata attribute value">
<node CREATED="1248161033087" ID="Freemind_Link_1922001516" MODIFIED="1248161040575" TEXT="Localizable">
<node CREATED="1248161041742" ID="Freemind_Link_1014887693" MODIFIED="1248161051290" TEXT="Dictionary object instead of String"/>
</node>
</node>
</node>
</node>
</node>
<node CREATED="1247140504398" ID="Freemind_Link_400703666" MODIFIED="1248157282051" POSITION="left" TEXT="Command Line Tools" VSHIFT="-128">
<node CREATED="1248004678531" ID="Freemind_Link_559301509" MODIFIED="1248004768694" TEXT="mdfind">
<node CREATED="1248004752468" ID="Freemind_Link_1355262870" MODIFIED="1248004912963" TEXT="finds files matching a given query"/>
<node CREATED="1248164405958" ID="Freemind_Link_248515343" MODIFIED="1248164410376" TEXT="Example">
<node CREATED="1248164412302" ID="Freemind_Link_515447032" MODIFIED="1248164449449" TEXT="Find all files with any metadata attribute value matching the string &quot;image&quot;">
<node CREATED="1248164449951" ID="Freemind_Link_217040116" MODIFIED="1248164457890" TEXT="mdfind image"/>
</node>
<node CREATED="1248164469279" ID="Freemind_Link_1305874665" MODIFIED="1248164484794" TEXT="Find all files that contain &quot;MyFavoriteAuthor&quot; in the kMDItemAuthor metadata attribute">
<node CREATED="1248164504160" ID="Freemind_Link_401170302" MODIFIED="1248164506947" TEXT="mdfind &quot;kMDItemAuthor == &apos;*MyFavoriteAuthor*&apos;&quot;"/>
</node>
<node CREATED="1248164988227" ID="Freemind_Link_105098762" MODIFIED="1248165034983" TEXT="Find all images containing &quot;apple&quot;, using the Spotlight menu syntax">
<node CREATED="1248165168639" ID="Freemind_Link_1994615241" MODIFIED="1248165185847" TEXT="mdfind -interpret &quot;apple kind:image&quot;"/>
<node CREATED="1248165276400" ID="Freemind_Link_949329844" MODIFIED="1248165363859" TEXT="Does not seem to perform localization, i.e. &#xa;    mdfind -interpret &quot;apple Art:Bilder&quot; &#xa;does not work on a german system.&#xa;"/>
</node>
<node CREATED="1248164547649" ID="Freemind_Link_567938616" MODIFIED="1248164559687" TEXT="Find &quot;live&quot; all files with any metadata attribute value matching the      string &quot;skateboard&quot;">
<node CREATED="1248164560537" ID="Freemind_Link_1407169892" MODIFIED="1248164571165" TEXT="mdfind -live skateboard"/>
<node CREATED="1248164577529" ID="Freemind_Link_1446942668" MODIFIED="1248164619125" TEXT="The find continues to run after gathering the initial results, providing a count of the number of files that match the query.&#xa;"/>
</node>
</node>
<node CREATED="1248004920214" ID="Freemind_Link_1175650027" LINK="http://developer.apple.com/documentation/Darwin/Reference/ManPages/man1/mdfind.1.html" MODIFIED="1248004920214" TEXT="developer.apple.com &gt; Documentation &gt; Darwin &gt; Reference &gt; ManPages &gt; Man1 &gt; Mdfind.1"/>
</node>
<node CREATED="1248004797966" ID="Freemind_Link_1747138239" MODIFIED="1248157301292" TEXT="mdimport" VSHIFT="27">
<node CREATED="1248004825582" ID="Freemind_Link_973984545" MODIFIED="1248004879179" TEXT="import file hierarchies into the metadata datastore"/>
<node CREATED="1248165571063" ID="Freemind_Link_1349153775" MODIFIED="1248165639980" TEXT="Also useful when testing own importers"/>
<node CREATED="1248163937252" ID="Freemind_Link_1923360152" MODIFIED="1248163940780" TEXT="Example">
<node CREATED="1248163941268" ID="Freemind_Link_498915710" MODIFIED="1248163966919" TEXT="list all the currently  recognized importers and their paths">
<node CREATED="1248163967500" ID="Freemind_Link_435206995" MODIFIED="1248163975087" TEXT="mdimport -L"/>
</node>
<node CREATED="1248165712178" ID="Freemind_Link_814876545" MODIFIED="1248165833272" TEXT="Print the schema file">
<node CREATED="1248165725715" ID="Freemind_Link_20541270" MODIFIED="1248165744638" TEXT="mdimport -X"/>
</node>
<node CREATED="1248164101039" ID="Freemind_Link_1191295093" MODIFIED="1248164153812" TEXT="Test the import for a given file (e.g. when testing/debugging own importers)">
<node CREATED="1248164121104" ID="Freemind_Link_1664742893" MODIFIED="1248164124883" TEXT="mdimport -d2 test.myCustomDocument"/>
</node>
</node>
<node CREATED="1248004888006" LINK="http://developer.apple.com/documentation/Darwin/Reference/ManPages/man1/mdimport.1.html" MODIFIED="1248004888006" TEXT="developer.apple.com &gt; Documentation &gt; Darwin &gt; Reference &gt; ManPages &gt; Man1 &gt; Mdimport.1"/>
</node>
<node CREATED="1247140525741" ID="Freemind_Link_958353022" MODIFIED="1248157303212" TEXT="mdls" VSHIFT="35">
<node CREATED="1248004834886" ID="Freemind_Link_1288599014" MODIFIED="1248004949468" TEXT="lists the metadata attributes for the specified file"/>
<node CREATED="1248164290483" ID="Freemind_Link_9550771" MODIFIED="1248164294184" TEXT="Example">
<node CREATED="1248164294699" ID="Freemind_Link_725313558" MODIFIED="1248166274018" TEXT="List the metadata attributes of Dictionary.app">
<node CREATED="1248164312932" ID="Freemind_Link_1885716995" MODIFIED="1248166325034" TEXT="mdls /Applications/Dictionary.app"/>
</node>
<node CREATED="1248166391313" ID="Freemind_Link_417922129" MODIFIED="1248166406723" TEXT="Print the ContentType of Dictionary.app">
<node CREATED="1248166408209" ID="Freemind_Link_515662655" MODIFIED="1248166409829" TEXT="mdls -name kMDItemContentType /Applications/Dictionary.app"/>
</node>
</node>
<node CREATED="1248004955556" ID="Freemind_Link_848226966" LINK="http://developer.apple.com/documentation/Darwin/Reference/ManPages/man1/mdls.1.html#//apple_ref/doc/man/1/mdls" MODIFIED="1248004955556" TEXT="developer.apple.com &gt; Documentation &gt; Darwin &gt; Reference &gt; ManPages &gt; Man1 &gt; Mdls.1.html# &gt;  &gt; Apple ref &gt; Doc &gt; Man &gt; 1 &gt; Mdls"/>
</node>
<node CREATED="1248004807893" ID="Freemind_Link_1454789582" MODIFIED="1248157307028" TEXT="mdutil" VSHIFT="43">
<node CREATED="1248004844246" ID="Freemind_Link_428793096" MODIFIED="1248166531303" TEXT="manage the metadata stores of mounted volumes"/>
<node CREATED="1248166539572" ID="Freemind_Link_978924787" MODIFIED="1248166542543" TEXT="Example">
<node CREATED="1248166543268" ID="Freemind_Link_771015951" MODIFIED="1248166703234" TEXT="Display the indexing status of all mounted volumes">
<node CREATED="1248166660799" ID="Freemind_Link_211595114" MODIFIED="1248166664082" TEXT="mdutil -a -s"/>
</node>
</node>
<node CREATED="1248004976147" LINK="http://developer.apple.com/documentation/Darwin/Reference/ManPages/man1/mdutil.1.html#//apple_ref/doc/man/1/mdutil" MODIFIED="1248004976147" TEXT="developer.apple.com &gt; Documentation &gt; Darwin &gt; Reference &gt; ManPages &gt; Man1 &gt; Mdutil.1.html# &gt;  &gt; Apple ref &gt; Doc &gt; Man &gt; 1 &gt; Mdutil"/>
</node>
<node CREATED="1248165465076" ID="Freemind_Link_124517697" MODIFIED="1248165470352" TEXT="mdcheckschema">
<node CREATED="1248166735297" ID="Freemind_Link_184696406" MODIFIED="1248166754525" TEXT="validates the given mdimporter schema files and indicates whether the schema could be successfully parsed."/>
<node CREATED="1248166971591" LINK="http://developer.apple.com/documentation/Darwin/Reference/ManPages/man1/mdcheckschema.1.html#//apple_ref/doc/man/1/mdcheckschema" MODIFIED="1248166971591" TEXT="developer.apple.com &gt; Documentation &gt; Darwin &gt; Reference &gt; ManPages &gt; Man1 &gt; Mdcheckschema.1.html# &gt;  &gt; Apple ref &gt; Doc &gt; Man &gt; 1 &gt; Mdcheckschema"/>
</node>
</node>
<node CREATED="1247605612068" ID="Freemind_Link_1884124871" MODIFIED="1248157278859" POSITION="left" TEXT="Query" VSHIFT="-93">
<node CREATED="1247605874724" ID="Freemind_Link_649918421" MODIFIED="1247605886103" TEXT="Defining a query">
<node CREATED="1247605635989" ID="Freemind_Link_678351355" LINK="#Freemind_Link_1832375445" MODIFIED="1248176349520" TEXT="Query Expression Syntax"/>
<node CREATED="1247605626726" ID="Freemind_Link_406303189" MODIFIED="1247605990665" TEXT="Using MDQuery" VSHIFT="-1">
<node CREATED="1247606169194" ID="Freemind_Link_1646585253" MODIFIED="1247606186798" TEXT="Result items: MDItem"/>
</node>
<node CREATED="1247605905973" ID="Freemind_Link_1537804346" MODIFIED="1248160443536" TEXT="Using NSMetadataQuery" VSHIFT="14">
<node CREATED="1247605980982" ID="Freemind_Link_1422733722" MODIFIED="1247605984713" TEXT="    Use NSPredicate"/>
<node CREATED="1248209988462" ID="Freemind_Link_841302985" MODIFIED="1248209991865" TEXT="Sorting"/>
<node CREATED="1247606422592" ID="Freemind_Link_305657830" MODIFIED="1247606458732" TEXT="&quot;value list attributes&quot;"/>
<node CREATED="1247606485385" ID="Freemind_Link_680588427" MODIFIED="1248157356053" TEXT="Scope" VSHIFT="22">
<node CREATED="1247606489665" ID="Freemind_Link_901124792" MODIFIED="1247606512133" TEXT="URLs"/>
<node CREATED="1247606513498" ID="Freemind_Link_1280476713" MODIFIED="1247606521973" TEXT="directory pathes"/>
<node CREATED="1247606522826" ID="Freemind_Link_177649516" MODIFIED="1247606530037" TEXT="predefined locations">
<node CREATED="1247606530506" ID="Freemind_Link_492784085" MODIFIED="1247606567718" TEXT="user&apos;s home directory"/>
<node CREATED="1247606568523" ID="Freemind_Link_1782384595" MODIFIED="1247606573951" TEXT="locally mounted volumes"/>
<node CREATED="1247606574739" ID="Freemind_Link_155982881" MODIFIED="1247606583319" TEXT="remotely mounted volumes"/>
</node>
</node>
<node CREATED="1247606199082" ID="Freemind_Link_408280979" MODIFIED="1247606214191" TEXT="Result items: NSMetadataItem"/>
</node>
</node>
<node CREATED="1247605996478" ID="Freemind_Link_1961169510" MODIFIED="1248157316157" TEXT="Running a query" VSHIFT="12">
<node CREATED="1247606006678" ID="Freemind_Link_1561087014" MODIFIED="1247606047098" TEXT="1. Initial results gathering"/>
<node CREATED="1247606047903" ID="Freemind_Link_1620804907" MODIFIED="1247606069578" TEXT="2. Live-update of results"/>
</node>
<node CREATED="1247606272188" ID="Freemind_Link_1569437574" MODIFIED="1248157319036" TEXT="Using the result" VSHIFT="33">
<node CREATED="1247606294909" ID="Freemind_Link_1272090422" MODIFIED="1248162211095" TEXT="Disable updates while accessing the result"/>
<node CREATED="1247606741503" ID="Freemind_Link_1729524093" MODIFIED="1247606752179" TEXT="Customize result using callbacks"/>
</node>
</node>
<node CREATED="1245791844899" HGAP="23" ID="Freemind_Link_606554577" MODIFIED="1248157253619" POSITION="left" TEXT="Spotlight Importer" VSHIFT="-22">
<node CREATED="1248157381241" ID="Freemind_Link_1187557910" MODIFIED="1248157468974" TEXT="Plugin-bundle to extract metadata information from files">
<node CREATED="1248158987505" ID="Freemind_Link_1305211994" MODIFIED="1248158997686" TEXT="located in">
<node CREATED="1248158998408" ID="Freemind_Link_1747760316" MODIFIED="1248159039861" TEXT="in application&apos;s bundle at MyApp.app/Contents/Library/Spotlight"/>
<node CREATED="1248159042665" ID="Freemind_Link_1206778302" MODIFIED="1248159064429" TEXT="~/Library/Spotlight"/>
<node CREATED="1248159067338" ID="Freemind_Link_64819919" MODIFIED="1248159080717" TEXT="/Library/Spotlight"/>
<node CREATED="1248159095211" ID="Freemind_Link_1758540539" MODIFIED="1248159099190" TEXT="Framework/PlugIn"/>
<node CREATED="1248159118307" ID="Freemind_Link_1840234329" MODIFIED="1248159145839" TEXT="System provided importers in: /System/Library/Spotlight"/>
</node>
</node>
<node CREATED="1248157488571" ID="Freemind_Link_952915108" MODIFIED="1248157523559" TEXT="Custom document formats need their own importer">
<node CREATED="1248159180724" ID="Freemind_Link_1162378318" MODIFIED="1248159227872" TEXT="Associated through uniform type identifiers (UTIs)"/>
</node>
<node CREATED="1248157594685" ID="Freemind_Link_1711731357" MODIFIED="1248158608372" TEXT="Templates for CFPlugin project and schema file in Xcode"/>
<node CREATED="1248157670695" ID="Freemind_Link_38729057" MODIFIED="1248160120506" TEXT="Additional Guidelines">
<node CREATED="1248160120996" ID="Freemind_Link_204502448" MODIFIED="1248160212145" TEXT="Don&apos;t store metadata in external files">
<node CREATED="1248160152269" ID="Freemind_Link_224742675" MODIFIED="1248160173192" TEXT="metadata in the same file as data"/>
<node CREATED="1248160175805" ID="Freemind_Link_350120051" MODIFIED="1248160198713" TEXT="System store of metadata &quot;volatile&quot;"/>
</node>
<node CREATED="1248160214670" ID="Freemind_Link_38654797" MODIFIED="1248160230422" TEXT="Import without user interaction"/>
<node CREATED="1248160231254" ID="Freemind_Link_664421776" MODIFIED="1248160254266" TEXT="Import when application not running"/>
<node CREATED="1248160255079" ID="Freemind_Link_155676636" MODIFIED="1248160293151" TEXT="User should be able to know/control metadata extracted/stored/searched">
<node CREATED="1248160293735" ID="Freemind_Link_1545350042" MODIFIED="1248160306249" TEXT="e.g. personal information"/>
</node>
</node>
<node CREATED="1248162878365" ID="Freemind_Link_1695302293" MODIFIED="1248162883737" TEXT="Schema.xml"/>
<node CREATED="1247771463686" ID="Freemind_Link_230894529" MODIFIED="1247771499296" TEXT="Use Xcode&apos;s Spotlight Plug-In template to create an import plug-in.  &#xa;The template will generate a unique PLUGIN_ID (UUID) for your importer. "/>
<node CREATED="1248163767240" ID="Freemind_Link_280038986" MODIFIED="1248163778661" TEXT="Performance">
<node CREATED="1248163795993" ID="Freemind_Link_72316804" MODIFIED="1248163869301" TEXT="Extract metadata quickly and minimal effort">
<node CREATED="1248163834953" ID="Freemind_Link_116974039" MODIFIED="1248163844997" TEXT="Consider this when designing the file format"/>
</node>
<node CREATED="1248163811297" ID="Freemind_Link_297348992" MODIFIED="1248163816012" TEXT="No memory leaks"/>
</node>
<node CREATED="1248163570884" ID="Freemind_Link_1457924010" MODIFIED="1248163577103" TEXT="Links">
<node CREATED="1248162340962" ID="Freemind_Link_1500661640" LINK="#Freemind_Link_214588584" MODIFIED="1248162370891" TEXT="Spotlight Importer Programming Guide"/>
<node CREATED="1245791855699" ID="Freemind_Link_313896625" MODIFIED="1248183183981" TEXT="Sample Code">
<node CREATED="1248183116806" ID="Freemind_Link_1756655081" LINK="#Freemind_Link_614589990" MODIFIED="1248183173872" TEXT="Spotlight"/>
<node CREATED="1248183122422" ID="Freemind_Link_889379704" LINK="#Freemind_Link_717067197" MODIFIED="1248183156095" TEXT="SpotlightFortunes"/>
<node CREATED="1248625379554" ID="Freemind_Link_1920941013" LINK="#Freemind_Link_1654985315" MODIFIED="1248625487472" TEXT="ImporterExample"/>
<node CREATED="1248625505692" ID="Freemind_Link_658531098" LINK="#Freemind_Link_1864343" MODIFIED="1248625531109" TEXT="SampleImporter"/>
</node>
</node>
</node>
<node CREATED="1248104427803" ID="Freemind_Link_614004474" MODIFIED="1248183989936" POSITION="right" TEXT="The &quot;Spotlight menu&quot; Query Syntax" VSHIFT="-153">
<node CREATED="1248164816311" ID="Freemind_Link_1393545378" MODIFIED="1248164823729" TEXT="Syntax Elements">
<node CREATED="1248104502325" ID="Freemind_Link_1836207457" MODIFIED="1248104507993" TEXT="&#x201c;AND&#x201d; &#x201c;NOT&#x201d; &#x201c;OR&#x201d;"/>
<node CREATED="1248104508629" ID="Freemind_Link_1873710916" MODIFIED="1248104512553" TEXT="( ... )"/>
<node CREATED="1248598587549" ID="Freemind_Link_478876862" MODIFIED="1248598596352" TEXT="&quot;...&quot;"/>
<node CREATED="1248104513349" ID="Freemind_Link_1790816065" MODIFIED="1248104523729" TEXT="attributeName:....">
<node CREATED="1248104548502" ID="Freemind_Link_1795432006" MODIFIED="1248105340214" TEXT="e.g. kind:music"/>
<node CREATED="1248104599999" ID="Freemind_Link_1131690621" MODIFIED="1248105347044" TEXT="name is localized. E.g. in Germany &quot;Art:Musik&quot;"/>
<node CREATED="1248105384609" ID="Freemind_Link_1029104151" MODIFIED="1248105434559" TEXT="name is case sensitive">
<node CREATED="1248105435051" ID="Freemind_Link_1390903191" MODIFIED="1248105436543" TEXT=" (i.e. &quot;art:Musik&quot; will not work, but &quot;Art:Musik&quot;)"/>
</node>
<node CREATED="1248106461941" ID="Freemind_Link_586536492" MODIFIED="1248106475140" TEXT="For a complete list checkout">
<node CREATED="1248106476244" ID="Freemind_Link_1456386205" MODIFIED="1248106478364" TEXT="en">
<node CREATED="1248106479156" ID="Freemind_Link_535660328" MODIFIED="1248106481896" TEXT="/System/Library/Frameworks/CoreServices.framework/Frameworks /Metadata.framework/Resources/English.lproj/schema.string"/>
</node>
<node CREATED="1248106485452" ID="Freemind_Link_98921105" MODIFIED="1248106487413" TEXT="de">
<node CREATED="1248106488558" ID="Freemind_Link_1947028112" MODIFIED="1248106506610" TEXT="/System/Library/Frameworks/CoreServices.framework/Frameworks /Metadata.framework/Resources/German.lproj/schema.string"/>
</node>
</node>
<node CREATED="1248107407238" ID="Freemind_Link_1525319816" MODIFIED="1248107427197" TEXT="For dates special values are defined">
<node CREATED="1248107427766" ID="Freemind_Link_1664828831" MODIFIED="1248107467354" TEXT="this week, &#xa;this month, &#xa;this year; &#xa;today, &#xa;yesterday, &#xa;tomorrow; &#xa;next week, &#xa;next month, &#xa;next year"/>
</node>
</node>
<node CREATED="1248105476612" ID="Freemind_Link_207775534" MODIFIED="1248105491540" TEXT="&quot;&lt;&quot; &quot;&gt;&quot; &quot;-&quot;">
<node CREATED="1248105492500" ID="Freemind_Link_899624110" MODIFIED="1248105545827" TEXT="date:&gt;1/1/07 will find any file modified after January 1, 2007. (The dates you enter must correspond to the short date format you have set in your International preferences.)&#xa;&#xa;date:&lt;12/31/07 will find any file modified before December 31, 2007.&#xa;&#xa;date:1/1/07-12/31/07 will find files modified between those two dates.&#xa;"/>
<node CREATED="1248105550629" ID="Freemind_Link_1374973207" MODIFIED="1248105550629" TEXT=""/>
</node>
</node>
<node CREATED="1248164755165" ID="Freemind_Link_430159711" MODIFIED="1248164805786" TEXT="&quot;mdfind -interpret ...&quot; also uses this syntax"/>
</node>
<node CREATED="1248004106575" ID="Freemind_Link_1084011252" MODIFIED="1248004609733" POSITION="right" TEXT="Spotlight Usage Tips">
<node CREATED="1248004144959" ID="Freemind_Link_1537034720" MODIFIED="1248102432723" TEXT="cmd-option-Space">
<node CREATED="1248004499279" ID="Freemind_Link_957755909" MODIFIED="1248004509704" TEXT="Open Spotlight search"/>
</node>
<node CREATED="1248598690857" ID="Freemind_Link_676691095" MODIFIED="1248598707472" TEXT="cmd-Space">
<node CREATED="1248598708561" ID="Freemind_Link_42613748" MODIFIED="1248598717101" TEXT="Open Spotlight menu"/>
<node CREATED="1248598972735" ID="Freemind_Link_1378933961" MODIFIED="1248598979321" TEXT="Return">
<node CREATED="1248598979863" ID="Freemind_Link_1835952006" MODIFIED="1248598998054" TEXT="Open selected file in Finder"/>
</node>
<node CREATED="1248598719489" ID="Freemind_Link_542457561" MODIFIED="1248598729247" TEXT="option-Return">
<node CREATED="1248598729761" ID="Freemind_Link_1245550250" MODIFIED="1248598756589" TEXT="Show all results in Finder"/>
</node>
<node CREATED="1248599000097" ID="Freemind_Link_377928991" MODIFIED="1248599006525" TEXT="cmd-Return">
<node CREATED="1248599007175" ID="Freemind_Link_287773869" MODIFIED="1248599013197" TEXT="Show selected file in Finder"/>
</node>
</node>
<node CREATED="1248102409046" ID="Freemind_Link_950815232" MODIFIED="1248102450948" TEXT="cmd-F">
<node CREATED="1248102451719" ID="Freemind_Link_1713208784" MODIFIED="1248102482204" TEXT="Open Spotlight search (from Finder). Only search Files and Folders, not other Spotlight items"/>
</node>
<node CREATED="1248004114639" ID="Freemind_Link_1378569046" MODIFIED="1248004140523" TEXT="cmd-F, cmd-F">
<node CREATED="1248004214185" ID="Freemind_Link_590295277" MODIFIED="1248004483954" TEXT="Second search directory is Home (not current directory)">
<node CREATED="1248004574089" LINK="http://www.macworld.com/article/133540/2008/05/105spotlighthome.html" MODIFIED="1248004574089" TEXT="macworld.com &gt; Article &gt; 133540 &gt; 2008 &gt; 05 &gt; 105spotlighthome"/>
</node>
</node>
<node CREATED="1248004156191" ID="Freemind_Link_781721238" MODIFIED="1248004162075" TEXT="cmd-shift-F">
<node CREATED="1248004199233" ID="Freemind_Link_957891931" MODIFIED="1248004205932" TEXT="Name search">
<node CREATED="1248004583163" LINK="http://www.macworld.com/article/133540/2008/05/105spotlighthome.html" MODIFIED="1248004583163" TEXT="macworld.com &gt; Article &gt; 133540 &gt; 2008 &gt; 05 &gt; 105spotlighthome"/>
</node>
</node>
<node CREATED="1248005533413" ID="Freemind_Link_1284042915" MODIFIED="1248005537142" TEXT="Change the dictionary used for Spotlight definitions">
<node CREATED="1248005566218" LINK="http://www.macosxhints.com/article.php?story=20090506121031203" MODIFIED="1248005566218" TEXT="macosxhints.com &gt; Article ? ..."/>
<node CREATED="1248005574622" ID="Freemind_Link_1080405336" MODIFIED="1248005613490" TEXT="The first dictionary found in the Dictionary.app (Lexikon) preferences is used"/>
<node CREATED="1248005632743" ID="Freemind_Link_449226086" MODIFIED="1248005692908" TEXT="For a German-English dictionary checkout BeoLingus">
<node CREATED="1248005699634" LINK="http://www.tekl.de/english/BeoLingus_German-English.html" MODIFIED="1248005699634" TEXT="tekl.de &gt; English &gt; BeoLingus German-English"/>
</node>
</node>
<node CREATED="1247769575253" ID="Freemind_Link_997901886" MODIFIED="1247769582016" TEXT="Spotlight and Timemachine">
<node CREATED="1248102645755" ID="Freemind_Link_174752438" MODIFIED="1248102736625" TEXT="Exclude backup volume from Spotlight"/>
</node>
<node CREATED="1248102630347" ID="Freemind_Link_1230581349" MODIFIED="1248102643655" TEXT="Spotlight and &quot;other&quot; Backups">
<node CREATED="1248102755486" ID="Freemind_Link_1532885213" MODIFIED="1248102757234" TEXT="Exclude backup volume from Spotlight"/>
<node CREATED="1248102667820" ID="Freemind_Link_1802456564" MODIFIED="1248102725337" TEXT="Make sure, Backup does not overwrite .Spotlight-V100 directory on backup volume"/>
</node>
<node CREATED="1248006835673" ID="Freemind_Link_1360973145" MODIFIED="1248006837629" TEXT="Change the default Spotlight Preview zoom level">
<node CREATED="1248006867666" ID="Freemind_Link_1756468937" MODIFIED="1248007798029" TEXT="Preview&apos;s default zoom when opening PDFs from Spotlight is defined by Preview&apos;s property &quot;Root -&gt; Preview -&gt; PVPDFSpotlightSelectionSize&quot; (~/Library -&gt; Preferences -&gt; com.apple.Preview.plist).&#xa;&#xa;Default: 28 (280%). &#xa;10 = 100%&#xa;&#xa;(Edit properties using e.g. Apple&apos;s Property List Editor)&#xa;"/>
<node CREATED="1248006843130" LINK="http://www.macosxhints.com/article.php?story=20051114175158162" MODIFIED="1248006843130" TEXT="macosxhints.com &gt; Article ? ..."/>
<node CREATED="1248007431229" LINK="http://www.macosxtips.co.uk/index_files/category-preview.html" MODIFIED="1248007431229" TEXT="macosxtips.co.uk &gt; Index files &gt; Category-preview"/>
</node>
<node CREATED="1248008706314" ID="Freemind_Link_1180327808" MODIFIED="1248008726263" TEXT="Run Spotlight searches based on Finder labels">
<node CREATED="1248008709371" ID="Freemind_Link_941525643" MODIFIED="1248008711574" TEXT="To find files by label with Spotlight, or in the Finder&apos;s find box, type label:1 (or any other number up to 7). The numbers don&apos;t seem to correspond exactly to the order in the Finder; but you can see them by doing mdls on files. Here&apos;s how each number corresponds to one of the Finder&apos;s label colors: 0 - None 1 - Gray 2 - Green 3 - Purple 4 - Blue 5 - Yellow 6 - Red 7 - Orange The actual key name is kMDItemFSLabel in the mdls output."/>
<node CREATED="1248008778370" LINK="http://www.macosxhints.com/article.php?story=20071231063704505" MODIFIED="1248008778370" TEXT="macosxhints.com &gt; Article ? ..."/>
</node>
<node CREATED="1248103330901" ID="Freemind_Link_1939996460" MODIFIED="1248103376148" TEXT="Add some &quot;other&quot; search attributes to the menu">
<node CREATED="1248103377196" ID="Freemind_Link_1310458898" MODIFIED="1248103493466" TEXT="System files - Include system Files, preference files, plug-ins, etc..."/>
<node CREATED="1248103443319" ID="Freemind_Link_227592756" MODIFIED="1248103485210" TEXT="Spotlight items - Includes contacts, email, calendars, bookmarks, etc..."/>
</node>
<node CREATED="1248104061427" ID="Freemind_Link_1503644076" MODIFIED="1248106969621" TEXT="option-Click on (+) in Search rules row">
<node CREATED="1248106953434" ID="Freemind_Link_335365496" MODIFIED="1248106955885" TEXT=" adds an &quot;Any/All/None&quot; subgroup row"/>
<node CREATED="1248104209670" ID="Freemind_Link_815876123" MODIFIED="1248104217298" TEXT="Can be nested"/>
<node CREATED="1248104218095" ID="Freemind_Link_879609704" MODIFIED="1248104234883" TEXT="build complex boolean expressions"/>
<node CREATED="1248106970753" ID="Freemind_Link_296992568" MODIFIED="1248106976326" TEXT="(+) becomes (&#x2026;)"/>
</node>
<node CREATED="1248104761475" ID="Freemind_Link_1094631019" MODIFIED="1248104771328" TEXT="Build-in calculator"/>
<node CREATED="1248104826221" ID="Freemind_Link_1498491" MODIFIED="1248104832174" TEXT="Start programs">
<node CREATED="1248104832774" ID="Freemind_Link_585647637" MODIFIED="1248104891570" TEXT="Add easy to recall words to Spotlight comment if you always forget the apps name"/>
</node>
<node CREATED="1248180907938" ID="Freemind_Link_70106249" MODIFIED="1248180962998" TEXT="Use &apos;mdfind -s path&apos; to show contents of smart folder">
<node CREATED="1248180964056" ID="Freemind_Link_741283186" MODIFIED="1248180986749" TEXT="Only documented in &quot;usage&quot; text when running mdfind without parameter"/>
</node>
</node>
<node CREATED="1247605871189" ID="Freemind_Link_466826079" MODIFIED="1248599428098" POSITION="right" TEXT="Sample Code" VSHIFT="123">
<node CREATED="1248259760499" ID="Freemind_Link_1414914038" MODIFIED="1248259804568" TEXT="Developer/Examples/AppKit/Spotlighter">
<node CREATED="1248259823381" ID="Freemind_Link_514592725" MODIFIED="1248259838001" TEXT="sample application demonstrating how to use the Cocoa NSMetadataQuery to access the new Spotlight feature in Mac OS 10.4 Tiger"/>
</node>
<node CREATED="1248625109380" ID="Freemind_Link_1799418356" MODIFIED="1248625170778" TEXT="Developer/Examples/Metadata">
<node CREATED="1248625171797" ID="Freemind_Link_1654985315" MODIFIED="1248625475064" TEXT="ImporterExample">
<node CREATED="1248625250326" ID="Freemind_Link_600473861" MODIFIED="1248625253882" TEXT="provide a complete example of how to write a metadata importer, along with declaring a UTI for your document as part of your application project."/>
</node>
<node CREATED="1248625208574" ID="Freemind_Link_1864343" MODIFIED="1248625214417" TEXT="SampleImporter">
<node CREATED="1248625537804" ID="Freemind_Link_1517161181" MODIFIED="1248626126453" TEXT="an example importer dealing with Application bundle meta information."/>
<node CREATED="1248626099513" ID="Freemind_Link_1686506802" MODIFIED="1248626120069" TEXT="Written in C (not Objective-C)"/>
</node>
</node>
<node CREATED="1247770076216" HGAP="23" ID="Freemind_Link_33239539" MODIFIED="1247770955915" TEXT="http://developer.apple.com/samplecode/SpotlightAPI/" VSHIFT="19">
<node CREATED="1247771551212" ID="Freemind_Link_1172081620" MODIFIED="1247771554810" TEXT="Some small sample programs that Show how to use the Spotlight API in your programs.">
<node CREATED="1247771555596" ID="Freemind_Link_1295811457" MODIFIED="1247771571088" TEXT="MDItemREf uses MDItemRef to get metadata for a file dragged into the window."/>
<node CREATED="1247771589813" ID="Freemind_Link_658385980" MODIFIED="1248182976455" TEXT="MDQueryRef1 does a query using MDQuery"/>
</node>
<node CREATED="1245877260362" ID="Freemind_Link_1319943380" LINK="http://developer.apple.com/samplecode/SpotlightAPI/" MODIFIED="1245877260362" TEXT="developer.apple.com &gt; Samplecode &gt; SpotlightAPI"/>
</node>
<node CREATED="1247769984078" ID="Freemind_Link_614589990" MODIFIED="1247769985713" TEXT="http://developer.apple.com/samplecode/Spotlight">
<node CREATED="1247771158763" ID="Freemind_Link_799477650" MODIFIED="1247771161046" TEXT="Sample code that shows how to write Spotlight Importers.">
<node CREATED="1247771188011" ID="Freemind_Link_57817374" MODIFIED="1247771190486" TEXT="a simple Spotlight importer for the old IFF image file format"/>
<node CREATED="1247771190987" ID="Freemind_Link_7017913" MODIFIED="1247771222135" TEXT="a Spotlight importer that shows how to define new attributes"/>
<node CREATED="1247771236148" ID="Freemind_Link_1656060986" MODIFIED="1247771237808" TEXT="a Spotlight importer that shows how to deal with a package based file format"/>
</node>
<node CREATED="1245791875962" ID="Freemind_Link_889554938" LINK="http://developer.apple.com/samplecode/Spotlight/" MODIFIED="1245791875962" TEXT="developer.apple.com &gt; Samplecode &gt; Spotlight"/>
</node>
<node CREATED="1247770027070" ID="Freemind_Link_717067197" MODIFIED="1247770028722" TEXT="http://developer.apple.com/samplecode/SpotlightFortunes">
<node CREATED="1247771308653" ID="Freemind_Link_1227166077" MODIFIED="1247771337170" TEXT="Demonstrates how to provision a Spotlight importer plug-in for a custom UTI, and how to use a NSMetadataQuery with bindings to display live query results in a table view.">
<node CREATED="1247771310614" ID="Freemind_Link_606856681" MODIFIED="1247771312490" TEXT="This sample was inspired by the classic Unix fortune program. Instead of reading entries from a monolithic .fortunes file, it uses Spotlight to find all files with the com.example.fortune-file UTI and displays them in a Cocoa table view. Since the focus of this sample is Spotlight&apos;s live query support, only minimal support for creating new fortune files is provided."/>
</node>
<node CREATED="1245877322441" ID="Freemind_Link_1353207697" LINK="http://developer.apple.com/samplecode/SpotlightFortunes/" MODIFIED="1245877322441" TEXT="developer.apple.com &gt; Samplecode &gt; SpotlightFortunes"/>
</node>
<node CREATED="1247770012703" HGAP="35" ID="Freemind_Link_558164473" MODIFIED="1247770958972" TEXT="http://developer.apple.com/samplecode/PredicateEditorSample" VSHIFT="3">
<node CREATED="1247770592773" ID="Freemind_Link_1295493492" MODIFIED="1247770594929" TEXT="demonstrates how to use the NSPredicateEditor class. The NSPredicateEditor class is a subclass of NSRuleEditor that is specialized for editing NSPredicate objects. This sample is intended to show how to use the many different features and aspects of this control and leverages Spotlight to search your Address Book."/>
<node CREATED="1245877370434" ID="Freemind_Link_1090613308" LINK="http://developer.apple.com/samplecode/PredicateEditorSample/index.html" MODIFIED="1245877370434" TEXT="developer.apple.com &gt; Samplecode &gt; PredicateEditorSample &gt; Index"/>
</node>
<node CREATED="1247770224460" ID="Freemind_Link_871594793" MODIFIED="1247770283737" TEXT="http://developer.apple.com/samplecode/PhotoSearch/">
<node CREATED="1247770542908" ID="Freemind_Link_214528255" MODIFIED="1247770545399" TEXT="uses Spotlight to perform a search for images on your computer. The NSPredicateEditor (introduced in Leopard) is used to create a custom search query."/>
<node CREATED="1245877468126" ID="Freemind_Link_772272764" LINK="http://developer.apple.com/samplecode/PhotoSearch/index.html" MODIFIED="1245877468126" TEXT="developer.apple.com &gt; Samplecode &gt; PhotoSearch &gt; Index"/>
</node>
<node CREATED="1247770296326" ID="Freemind_Link_1890874206" MODIFIED="1247770297729" TEXT="http://developer.apple.com/samplecode/SBSetFinderComment">
<node CREATED="1247770937421" ID="Freemind_Link_942697994" MODIFIED="1247770939857" TEXT="Set/Get Finder Comments using Scripting Bridge"/>
</node>
<node CREATED="1247770327309" ID="Freemind_Link_861788324" MODIFIED="1247770329018" TEXT="http://developer.apple.com/samplecode/WhackedTV/">
<node CREATED="1247770384912" ID="Freemind_Link_596266784" MODIFIED="1247770387204" TEXT="demonstrate the .noindex technique for holding off Spotlight from prematurely indexing files being written by Sequence Grabber. This avoids frame droppage."/>
<node CREATED="1245877518005" ID="Freemind_Link_1416434819" LINK="http://developer.apple.com/samplecode/WhackedTV/" MODIFIED="1245877518005" TEXT="developer.apple.com &gt; Samplecode &gt; WhackedTV"/>
</node>
<node CREATED="1247770767441" ID="Freemind_Link_1416808680" MODIFIED="1247770769237" TEXT="http://developer.apple.com/samplecode/DepartmentAndEmployees/listing4.html">
<node CREATED="1247770770049" ID="Freemind_Link_704786909" MODIFIED="1247770825555" TEXT="extract useful information from the file formats for your document, and set the values into the attribute  dictionary for Spotlight to include"/>
</node>
<node CREATED="1247771034175" ID="Freemind_Link_440430027" MODIFIED="1247771101037" TEXT="http://developer.apple.com/samplecode/CoreRecipes/listing29.html">
<node CREATED="1247771041456" ID="Freemind_Link_1316767091" MODIFIED="1247771082316" TEXT="use Spotlight to find the other Core Recipes store files on the disk (to load into the &quot;Imported&quot; section of the view.)  Here we set up a predicate to match the UTI type (the content type of the file), and then start a metadata query with it.  We get notifications each time the content changes. "/>
</node>
<node CREATED="1247834016452" ID="Freemind_Link_1415059851" MODIFIED="1247834029192" TEXT="http://developer.apple.com/samplecode/iSpend/">
<node CREATED="1247834065749" ID="Freemind_Link_1588499038" MODIFIED="1247834067593" TEXT="Demonstrates how to add Copy and Paste, Drag and Drop, Services, NSDatePicker, sorting, Undo support, NSViewAnimation, and searching support."/>
<node CREATED="1247834049244" ID="Freemind_Link_1922873757" LINK="http://developer.apple.com/samplecode/iSpend/" MODIFIED="1247834049244" TEXT="developer.apple.com &gt; Samplecode &gt; ISpend"/>
</node>
</node>
<node CREATED="1245790787572" ID="_" MODIFIED="1248599431743" POSITION="right" TEXT="References" VSHIFT="115">
<node CREATED="1248000927379" ID="Freemind_Link_1405963742" MODIFIED="1248000936143" TEXT="Apple">
<node CREATED="1245791910604" ID="Freemind_Link_1259476200" MODIFIED="1245791943297" TEXT="Working with Spotlight (Tiger Developer Overview Series)">
<node CREATED="1245791951771" LINK="http://developer.apple.com/macosx/spotlight.html" MODIFIED="1245791951771" TEXT="developer.apple.com &gt; Macosx &gt; Spotlight"/>
</node>
<node CREATED="1245790797015" ID="Freemind_Link_1509095796" MODIFIED="1245790819963" TEXT="Spotlight Overview">
<node CREATED="1245790900907" ID="Freemind_Link_963026291" LINK="http://developer.apple.com/documentation/Carbon/Conceptual/MetadataIntro/MetadataIntro.html" MODIFIED="1245790900907" TEXT="developer.apple.com &gt; Documentation &gt; Carbon &gt; Conceptual &gt; MetadataIntro &gt; MetadataIntro"/>
</node>
<node CREATED="1245791101565" ID="Freemind_Link_1084852031" MODIFIED="1245791103524" TEXT="Spotlight Query Programming Guide">
<node CREATED="1245791107914" ID="Freemind_Link_1983659439" LINK="http://developer.apple.com/documentation/Carbon/Conceptual/SpotlightQuery/SpotlightQuery.html" MODIFIED="1245877558444" TEXT="developer.apple.com &gt; Documentation &gt; Carbon &gt; Conceptual &gt; SpotlightQuery &gt; SpotlightQuery">
<font NAME="SansSerif" SIZE="12"/>
</node>
<node CREATED="1248176270919" ID="Freemind_Link_1832375445" MODIFIED="1248176281304" TEXT="Query Expression Syntax">
<node CREATED="1248176311788" LINK="http://developer.apple.com/documentation/carbon/conceptual/spotlightquery/concepts/queryformat.html" MODIFIED="1248176311788" TEXT="developer.apple.com &gt; Documentation &gt; Carbon &gt; Conceptual &gt; Spotlightquery &gt; Concepts &gt; Queryformat"/>
</node>
</node>
<node CREATED="1245790991037" ID="Freemind_Link_1710335322" MODIFIED="1248160851574" TEXT="Spotlight Metadata Attributes Reference">
<node CREATED="1245791001267" ID="Freemind_Link_579623364" LINK="http://developer.apple.com/documentation/Carbon/Reference/MetadataAttributesRef/MetadataAttrRef.html" MODIFIED="1245791001267" TEXT="developer.apple.com &gt; Documentation &gt; Carbon &gt; Reference &gt; MetadataAttributesRef &gt; MetadataAttrRef"/>
</node>
<node CREATED="1245790952727" ID="Freemind_Link_214588584" MODIFIED="1245790955823" TEXT="Spotlight Importer Programming Guide">
<node CREATED="1245790962576" ID="Freemind_Link_817957712" LINK="http://developer.apple.com/documentation/Carbon/Conceptual/MDImporters/MDImporters.html" MODIFIED="1245790962576" TEXT="developer.apple.com &gt; Documentation &gt; Carbon &gt; Conceptual &gt; MDImporters &gt; MDImporters"/>
</node>
<node CREATED="1247986224984" ID="Freemind_Link_1805027414" MODIFIED="1247986255348" TEXT="Spotlight Reference Collection">
<node CREATED="1247986284906" ID="Freemind_Link_1675314414" LINK="http://developer.apple.com/documentation/Carbon/Reference/SpotlightReference_Collection/" MODIFIED="1247986284906" TEXT="developer.apple.com &gt; Documentation &gt; Carbon &gt; Reference &gt; SpotlightReference Collection"/>
</node>
<node CREATED="1248001840894" ID="Freemind_Link_1135559128" MODIFIED="1248001855868" TEXT="Where does Spotlight search?">
<node CREATED="1248009176950" ID="Freemind_Link_654473859" MODIFIED="1248009201921" TEXT="All Home folders (local and network-based, as well as FileVault and non-FileVault). This includes:&#xa;The Documents, Movies, Music, and Pictures folders&#xa;The Trash of all users and each mounted volume.&#xa;~/Library/Metadata/&#xa;~/Library/Caches/Metadata/&#xa;~/Library/Mail/&#xa;~/Library/Caches/com.apple.AddressBook/Metadata/&#xa;~/Library/PreferencePanes/&#xa;&#xa;Spotlight also searches these non-Home folder locations by default:&#xa;/Library/PreferencePanes/&#xa;/System/Library/PreferencePanes/&#xa;/Applications&#xa;"/>
<node CREATED="1248001876524" ID="Freemind_Link_1103156122" LINK="http://support.apple.com/kb/TA23187" MODIFIED="1248001876524" TEXT="support.apple.com &gt; Kb &gt; TA23187"/>
</node>
<node CREATED="1248127287325" ID="Freemind_Link_224917685" MODIFIED="1248127350081" TEXT="Spotlight Plugins (Downloads)">
<node CREATED="1248127314223" LINK="http://www.apple.com/downloads/macosx/spotlight/index1.html" MODIFIED="1248127314223" TEXT="apple.com &gt; Downloads &gt; Macosx &gt; Spotlight &gt; Index1"/>
</node>
<node CREATED="1248188754602" ID="Freemind_Link_1089909766" MODIFIED="1248188759156" TEXT="Search Kit Programming Guide">
<node CREATED="1248188831954" LINK="http://developer.apple.com/DOCUMENTATION/UserExperience/Conceptual/SearchKitConcepts/searchKit_intro/searchKit_intro.html" MODIFIED="1248188831954" TEXT="developer.apple.com &gt; DOCUMENTATION &gt; UserExperience &gt; Conceptual &gt; SearchKitConcepts &gt; SearchKit intro &gt; SearchKit intro"/>
</node>
</node>
<node CREATED="1248000964252" ID="Freemind_Link_341297110" MODIFIED="1248000969704" TEXT="Third Party">
<node CREATED="1248000971620" ID="Freemind_Link_1807677161" MODIFIED="1248001007673" TEXT="Spotlight tips (The X Lab)">
<node CREATED="1248001011970" LINK="http://www.thexlab.com/faqs/stopspotlightindex.html" MODIFIED="1248001011970" TEXT="thexlab.com &gt; Faqs &gt; Stopspotlightindex"/>
</node>
<node CREATED="1248104310641" ID="Freemind_Link_1556495563" MODIFIED="1248104339349" TEXT="Spotlight Strikes Back: In Leopard, It Works Great">
<node CREATED="1248104318384" LINK="http://db.tidbits.com/article/9283" MODIFIED="1248104318384" TEXT="db.tidbits.com &gt; Article &gt; 9283"/>
</node>
<node CREATED="1248104330945" ID="Freemind_Link_1343393196" MODIFIED="1248105155782" TEXT="Spotlight&#x2019;s Secret Search Syntax">
<node CREATED="1248105162609" LINK="http://www.mcelhearn.com/?p=309" MODIFIED="1248105162609" TEXT="mcelhearn.com &gt;  ? ..."/>
</node>
<node CREATED="1248107858249" ID="Freemind_Link_1340888981" MODIFIED="1248107934982" TEXT="Chapter &quot;Advanced Spotlight Menu Searches&quot;, OS X 10.5 Missing Manual, David Pogue (excerpt)">
<node CREATED="1248107895973" LINK="http://www.macosxhints.com/dlfiles/spotlight_cmds.pdf" MODIFIED="1248107895973" TEXT="macosxhints.com &gt; Dlfiles &gt; Spotlight cmds"/>
</node>
<node CREATED="1248126118921" ID="Freemind_Link_627226103" MODIFIED="1248126144783" TEXT="Programming with Spotlight (MacDevCenter.com)">
<node CREATED="1248126156340" LINK="http://macdevcenter.com/lpt/a/6034" MODIFIED="1248126156340" TEXT="macdevcenter.com &gt; Lpt &gt; A &gt; 6034"/>
</node>
<node CREATED="1248598772627" ID="Freemind_Link_406294305" MODIFIED="1248598786109" TEXT="Leopard - Optimizing Spotlight Search ">
<node CREATED="1248598793228" LINK="http://www.usingmac.com/2007/11/22/leopard-optimizing-spotlight-search" MODIFIED="1248598793228" TEXT="usingmac.com &gt; 2007 &gt; 11 &gt; 22 &gt; Leopard-optimizing-spotlight-search"/>
</node>
</node>
</node>
<node CREATED="1248627450788" ID="Freemind_Link_739136913" MODIFIED="1248627481547" POSITION="right" TEXT="Copyright 2009, Udo Borkowski, Aachen"/>
</node>
</map>
